#ifndef MYWINDOW3_MEMBER_LIBRARIAN_H_INCLUDED
#define MYWINDOW3_LIBRARIAN_H_INCLUDED
#include<gtkmm.h>
#include "mywindow3_librarian_function.h"
#include "guest_user.h"
//LIBRARIAN LOGIN :CONSTRUCTOR
mywindow3::mywindow3()

{   set_modal(true);
    set_position(Gtk::WIN_POS_CENTER);
    set_default_size(400, 100);
    set_title("LOGIN");

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    vbox->add(*grid);

    Gtk::Label *lusername = Gtk::manage(new Gtk::Label("Username: "));
    grid->attach(*lusername, 0, 0, 1, 1);

    Gtk::Label *lpassword = Gtk::manage(new Gtk::Label("Password: "));
    grid->attach(*lpassword, 0, 1, 1, 1);

    Gtk::Entry *eusername = Gtk::manage(new Gtk::Entry());
    eusername->set_hexpand(true);
    grid->attach(*eusername, 1, 0, 2, 1);

    Gtk::Entry *epassword = Gtk::manage(new Gtk::Entry());
    epassword->set_hexpand(true);
    epassword->set_visibility(false);
    grid->attach(*epassword, 1, 1, 2, 1);

    Gtk::Button *blogin = Gtk::manage(new Gtk::Button("Login"));
    blogin->signal_clicked().connect(sigc::bind<Gtk::Entry*, Gtk::Entry*>(sigc::mem_fun(*this, &mywindow3::on_login_click), eusername, epassword));
    grid->attach(*blogin, 2, 3, 1, 1);

    vbox->show_all();
}

//LIBRARIAN LOGIN :DESTRUCTOR

mywindow3::~mywindow3()
{

}

//MEMBER FUNCTION OF LIBRARIAN LOGIN

void mywindow3::on_login_click(Gtk::Entry *euname, Gtk::Entry *epword)
{
    if(euname->get_text().compare("librarian") == 0 && epword->get_text().compare("password") == 0)
    {
        Gtk::MessageDialog dlg("You are now logged in.", false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
        dlg.set_title("SUCCESS");
        dlg.run();
        hide();

        open_new_window_lib *popup = new open_new_window_lib;
        popup->popup = new o_window_lib;
        popup->popup->show();
    }
else
    {
        Gtk::MessageDialog dlg("Unknown username or password.", false, Gtk::MESSAGE_ERROR, Gtk::BUTTONS_OK, true);
        dlg.set_title("ERROR");
        dlg.run();
    }
}
o_window_lib::o_window_lib(){
    set_position(Gtk::WIN_POS_CENTER);

     //SIZE OF THE WINDOWS

    set_default_size(500, 200);
    set_title("LIBRARIAN LOGIN");

    //VIRTUAL BOX

    Gtk::Box *vbox = Gtk::manage(new Gtk::Box(Gtk::ORIENTATION_VERTICAL, 0));
    add(*vbox);

    //ADDING A GRID TO THE VBOX

    Gtk::Grid *grid = Gtk::manage(new Gtk::Grid);
    grid->set_border_width(10);
    grid->set_row_spacing(5);
    grid->set_column_spacing(10);
    vbox->add(*grid);

    //A LABEL AT THE TOP

    Gtk::Label *lusername = Gtk::manage(new Gtk::Label("WELCOME LIBRARIAN"));
    grid->attach(*lusername, 0, 0, 1, 1);

    Gtk::Label *space = Gtk::manage(new Gtk::Label(""));
    grid->attach(*space, 1, 1, 1, 1);

    //ADDING BUTTONS

    Gtk::Button *b1 = Gtk::manage(new Gtk::Button("CREATE NEW BOOK"));
    b1->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button1_click));
    grid->attach(*b1, 1, 2, 1, 1);
    Gtk::Button *b2 = Gtk::manage(new Gtk::Button("MODIFY BOOK DETAILS"));
    b2->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button2_click));
    grid->attach(*b2, 1, 3, 1, 1);
    Gtk::Button *b3 = Gtk::manage(new Gtk::Button("REMOVE A BOOK"));
    b3->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button3_click));
    grid->attach(*b3, 1, 4, 1, 1);
    Gtk::Button *b4 = Gtk::manage(new Gtk::Button("VIEW RECORDS"));
    b4->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button4_click));
    grid->attach(*b4, 1, 5, 1, 1);
    Gtk::Button *b5 = Gtk::manage(new Gtk::Button("RULES AND REGULATIONS"));
    b5->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button5_click));
    grid->attach(*b5, 1, 7, 1, 1);

    Gtk::Button *b6 = Gtk::manage(new Gtk::Button("VIEW BOOK REQUESTS"));
    b6->signal_clicked().connect(sigc::mem_fun(*this, &o_window_lib::on_button6_click));
    grid->attach(*b6, 1, 6, 1, 1);

    vbox->show_all();

};
o_window_lib::~o_window_lib(){
    std::cout<<"Deleting mywindow";
    std::map<int, create_book*>::iterator iter;
    for (iter = popups.begin(); iter != popups.end(); iter++)
    {
        create_book *popup = iter->second;

        std::stringstream ss;
        ss << "Deleting Window '" << iter->first << "'";
        std::cout << ss.str() << std::endl;

        delete popup->popup;
        delete popup;}
};

void o_window_lib::on_button1_click(){
    create_book *popup = new create_book;
    popup->popup = new c_book;
    popup->popup->show();
}
void o_window_lib::on_button2_click(){
    modify_book *popup = new modify_book;
    popup->popup = new m_book;
    popup->popup->show();
}
void o_window_lib::on_button3_click(){
    remove_book *popup = new remove_book;
    popup->popup = new r_lib_book;
    popup->popup->show();
}
void o_window_lib::on_button4_click(){
    view_lib_records *popup = new view_lib_records;
    popup->popup = new v_lib_rec;
    popup->popup->show();
}
void o_window_lib::on_button5_click(){
    view_lib_rar *popup = new view_lib_rar;
    popup->popup = new v_lib_rar;
    popup->popup->show();
}
void o_window_lib::on_button6_click(){
    view_book_req *popup = new view_book_req;
    popup->popup = new v_book_req;
    popup->popup->show();
}

#endif
